chrome.runtime.onInstalled.addListener(() => {
    console.log("Ethics Chatbot Extension Installed");

    // Ensure alarms are properly created
    if (chrome.alarms) {
        chrome.alarms.create("resetUsage", { periodInMinutes: 1440 });
        console.log("Alarm set to reset query count daily.");
    } else {
        console.error("chrome.alarms API is not available.");
    }
});

// Alarm event listener
chrome.alarms.onAlarm.addListener((alarm) => {
    if (alarm.name === "resetUsage") {
        chrome.storage.local.set({ "queryCount": 0 });
        console.log("Query count reset for the day.");
    }
});