document.addEventListener("DOMContentLoaded", function () {
    const chatBox = document.getElementById("chat-box");
    const userInput = document.getElementById("user-input");
    const sendBtn = document.getElementById("send-btn");
    const usageInfo = document.getElementById("usage-info");

    function showSpinner() {
        const spinner = document.createElement("div");
        spinner.id = "loading-spinner";
        spinner.classList.add("spinner");
        chatBox.appendChild(spinner);
    }

    function removeSpinner() {
        const spinner = document.getElementById("loading-spinner");
        if (spinner) spinner.remove();
    }

    function formatResponse(text) {
        // Convert ### Headings to <strong> for bold formatting
        text = text.replace(/###\s*(.+)/g, "<strong>$1</strong>");

        // Convert numbered list titles (1. Title) to bold
        text = text.replace(/(\d+\.)\s*\*\*(.+?)\*\*/g, "<strong>$1 $2</strong>");

        return text.replace(/\n/g, "<br>"); // Convert new lines to HTML breaks
    }

    // Append bot response with a (disabled) copy button
    function appendBotResponse(responseText) {
        removeSpinner(); // Ensure spinner is removed before adding response

        const botMessage = document.createElement("div");
        botMessage.classList.add("bot-message");

        const messageContent = document.createElement("span");
        messageContent.innerHTML = formatResponse(responseText);

        // Copy button (disabled for now)
        const copyBtn = document.createElement("button");
        copyBtn.classList.add("copy-btn");
        copyBtn.innerHTML = "📋";
        copyBtn.disabled = true; // Feature coming soon
        copyBtn.title = "Coming Soon!";
        
        botMessage.appendChild(messageContent);
        botMessage.appendChild(copyBtn);
        chatBox.appendChild(botMessage);

        chatBox.scrollTop = chatBox.scrollHeight; // Auto-scroll to latest message
    }

    // Check usage limit on load
    chrome.storage.local.get(["queryCount"], function (result) {
        let queryCount = result.queryCount || 0;
        let maxQueries = 10; // Adjust based on your limit
        usageInfo.textContent = `Queries left: ${maxQueries - queryCount}`;
    });

    sendBtn.addEventListener("click", function () {
        const userText = userInput.value.trim();
        if (userText === "") return;

        chrome.storage.local.get(["queryCount"], function (result) {
            let queryCount = result.queryCount || 0;
            let maxQueries = 10;

            if (queryCount >= maxQueries) {
                appendBotResponse("🚫 Daily limit reached. Upgrade for more.");
                return;
            }

            // Append user message
            const userMessage = document.createElement("div");
            userMessage.classList.add("user-message");
            userMessage.textContent = userText;
            chatBox.appendChild(userMessage);
            userInput.value = "";

            showSpinner(); // Show loading spinner

            fetch("https://ethics.aiplifysolutions.com/ai-ethics-chatbot-extension/server/chatbot.php", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify({ query: userText })
            })
            .then(response => response.json())
            .then(data => {
                appendBotResponse(data.response);

                // Increase usage count
                chrome.storage.local.set({ "queryCount": queryCount + 1 }, function () {
                    usageInfo.textContent = `Queries left: ${maxQueries - (queryCount + 1)}`;
                });
            })
            .catch(error => {
                appendBotResponse("❌ Error fetching response.");
            });
        });
    });
});