<?php
header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);
$query = $data["query"] ?? "";

if (!$query) {
    echo json_encode(["response" => "Please ask a question about AI ethics."]);
    exit;
}

// Define allowed ethics-related keywords
$allowed_keywords = [
    "ethics", "ai ethics", "responsible ai", "transparency", "accountability",
    "bias", "fairness", "privacy", "data ethics", "ethical concerns", "ai governance",
    "algorithmic bias", "tech ethics", "regulations", "ethical decision making"
];

// Check if query contains at least one ethics-related keyword
$is_valid_query = false;
foreach ($allowed_keywords as $keyword) {
    if (strpos($query, $keyword) !== false) {
        $is_valid_query = true;
        break;
    }
}

// Reject unrelated queries
if (!$is_valid_query) {
    echo json_encode(["response" => "This chatbot only answers AI ethics-related questions."]);
    exit;
}

$apiKey = "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";
$apiUrl = "https://api.openai.com/v1/chat/completions";

$postData = json_encode([
    "model" => "gpt-4o-mini",
    "messages" => [
        ["role" => "system", "content" => "You are an AI Ethics expert."],
        ["role" => "user", "content" => $query]
    ],
    "temperature" => 0.7
]);

$ch = curl_init($apiUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Authorization: Bearer $apiKey",
    "Content-Type: application/json"
]);

$response = curl_exec($ch);
curl_close($ch);

$responseData = json_decode($response, true);
$botResponse = $responseData["choices"][0]["message"]["content"] ?? "I couldn't fetch a response.";

echo json_encode(["response" => $botResponse]);
?>